// VoRS -- Vo(IP) Really Simple
// Copyright (C) 2024 Sergey Matveev <stargrave@stargrave.org>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, version 3 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

package main

import (
	"fmt"
	"sort"

	"github.com/jroimartin/gocui"
)

var (
	GUI       *gocui.Gui
	GUIReady  bool
	GUIReadyC = make(chan struct{})
	GUIMaxY   int
)

func guiQuit(gui *gocui.Gui, v *gocui.View) error {
	Finish <- struct{}{}
	return gocui.ErrQuit
}

func mute(gui *gocui.Gui, v *gocui.View) error {
	Muted = !Muted
	return nil
}

func guiLayout(gui *gocui.Gui) error {
	var maxX int
	maxX, GUIMaxY = gui.Size()
	prevY := 0
	v, err := gui.SetView("logs", 0, prevY, maxX-1, prevY+10+2)
	prevY += 10 + 2
	if err != nil {
		if err != gocui.ErrUnknownView {
			return err
		}
		v.Title = fmt.Sprintf("Logs name=%s room=%s", *Name, *Room)
		v.Autoscroll = true
	}
	sids := make([]int, 0, len(Streams))
	for sid := range Streams {
		sids = append(sids, int(sid))
	}
	sort.Ints(sids)
	var stream *Stream
	for _, sid := range sids {
		stream = Streams[byte(sid)]
		v, err = gui.SetView(stream.name, 0, prevY, maxX/2-1, prevY+2)
		if err != nil {
			if err != gocui.ErrUnknownView {
				return err
			}
			v.Title = stream.name
		}
		_, err = gui.SetView(stream.name+"-vol", maxX/2, prevY, maxX-1, prevY+2)
		prevY += 3
		if err != nil {
			if err != gocui.ErrUnknownView {
				return err
			}
		}
	}
	if !GUIReady {
		close(GUIReadyC)
		GUIReady = true
		gui.SetCurrentView(*Name)
	}
	return nil
}
