package main

import (
	"crypto/rand"
	"encoding/base64"
	"flag"
	"fmt"
	"io"
	"log"
	"os"

	"github.com/flynn/noise"
	vors "go.stargrave.org/vors/internal"
)

func main() {
	pub := flag.Bool("pub", false, "print Base64 public key")
	version := flag.Bool("version", false, "print version")
	warranty := flag.Bool("warranty", false, "print warranty information")
	flag.Parse()
	if *warranty {
		fmt.Println(vors.Warranty)
		return
	}
	if *version {
		fmt.Println(vors.GetVersion())
		return
	}
	if *pub {
		data, err := io.ReadAll(os.Stdin)
		if err != nil {
			log.Fatal(err)
		}
		if len(data) != 2*32 {
			log.Fatal("wrong length")
		}
		fmt.Printf("%s\n", base64.RawURLEncoding.EncodeToString(data[32:]))
		return
	}
	kp, err := noise.DH25519.GenerateKeypair(rand.Reader)
	if err != nil {
		log.Fatal(err)
	}
	os.Stdout.Write(kp.Private[:])
	os.Stdout.Write(kp.Public[:])
}
