// VoRS -- Vo(IP) Really Simple
// Copyright (C) 2024 Sergey Matveev <stargrave@stargrave.org>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, version 3 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

package main

import (
	"flag"
	"os"
	"sort"
	"strings"
	"time"

	"github.com/jroimartin/gocui"
)

var (
	NoGUI     = flag.Bool("tuiless", false, "no fancy TUI, only logs")
	GUI       *gocui.Gui
	GUIReady  bool
	GUIReadyC = make(chan struct{})
)

func guiQuit(g *gocui.Gui, v *gocui.View) error {
	go func() {
		time.Sleep(100 * time.Millisecond)
		os.Exit(0)
	}()
	return gocui.ErrQuit
}

func guiLayout(gui *gocui.Gui) error {
	maxX, _ := gui.Size()
	prevY := 0
	v, err := gui.SetView("logs", 0, prevY, maxX-1, prevY+10+2)
	prevY += 10 + 2
	if err != nil {
		if err != gocui.ErrUnknownView {
			return err
		}
		v.Title = "Logs"
		v.Autoscroll = true
	}
	roomNames := make([]string, 0, len(Rooms))
	for n := range Rooms {
		roomNames = append(roomNames, n)
	}
	sort.Strings(roomNames)
	var now time.Time
	for _, name := range roomNames {
		room := Rooms[name]
		lines := room.Stats(now)
		v, err = gui.SetView(room.name, 0, prevY, maxX-1, prevY+1+len(lines))
		prevY += 2 + len(lines)
		if err != nil {
			if err != gocui.ErrUnknownView {
				return err
			}
			title := room.name
			if room.key != "" {
				title += " protected"
			}
			v.Title = title
			v.Clear()
			v.Write([]byte(strings.Join(lines, "\n")))
		}
	}
	if !GUIReady {
		close(GUIReadyC)
		GUIReady = true
	}
	return nil
}
