package main

import (
	"fmt"
	"sort"
	"sync"
	"time"

	"github.com/dustin/go-humanize"
	vors "go.stargrave.org/vors/internal"
)

var (
	Rooms  = map[string]*Room{}
	RoomsM sync.Mutex
)

type Room struct {
	name  string
	key   string
	peers map[byte]*Peer
	alive chan struct{}
}

func (room *Room) Stats(now time.Time) []string {
	sids := make([]int, 0, len(room.peers))
	for sid := range room.peers {
		sids = append(sids, int(sid))
	}
	sort.Ints(sids)
	lines := make([]string, 0, len(sids))
	for _, sid := range sids {
		peer := room.peers[byte(sid)]
		if peer == nil {
			continue
		}
		line := fmt.Sprintf(
			"%12s  |  %s | Rx/Tx/Bad: %s / %s / %s |  %s / %s",
			peer.name,
			peer.addr,
			humanize.Comma(peer.stats.pktsRx),
			humanize.Comma(peer.stats.pktsTx),
			humanize.Comma(peer.stats.bads),
			humanize.IBytes(peer.stats.bytesRx),
			humanize.IBytes(peer.stats.bytesTx),
		)
		if peer.stats.last.Add(vors.ScreenRefresh).After(now) {
			line += "  |  " + vors.CGreen + "TALK" + vors.CReset
		}
		lines = append(lines, line)
	}
	return lines
}
