package internal

import (
	"bytes"
	"io"
	"net"

	"github.com/flynn/noise"
)

const NoisePrologue = "VoRS v2"

var NoiseCipherSuite = noise.NewCipherSuite(
	noise.DH25519,
	noise.CipherChaChaPoly,
	noise.HashBLAKE2s,
)

func PktRead(conn net.Conn) (buf []byte, err error) {
	buf = make([]byte, 2)
	_, err = io.ReadFull(conn, buf[:2])
	if err != nil {
		return
	}
	buf = make([]byte, int(buf[0])<<8|int(buf[1]))
	_, err = io.ReadFull(conn, buf)
	return
}

func PktWrite(conn net.Conn, buf []byte) (err error) {
	_, err = io.Copy(conn, bytes.NewReader(append([]byte{
		byte((len(buf) & 0xFF00) >> 8),
		byte((len(buf) & 0x00FF) >> 0),
	}, buf...)))
	return
}
