package internal

import (
	"net"
	"time"
)

const (
	CmdPing = "PING"
	CmdPong = "PONG"
	CmdAdd  = "ADD"
	CmdDel  = "DEL"
)

var (
	PingTime      = 10 * time.Second
	ScreenRefresh = 200 * time.Millisecond
)

func IPHdrLen(ip net.IP) uint64 {
	if ip.To4() == nil {
		return 40
	}
	return 20
}
