// VoRS -- Vo(IP) Really Simple
// Copyright (C) 2024-2025 Sergey Matveev <stargrave@stargrave.org>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, version 3 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

package main

import (
	"log"

	"go.stargrave.org/opus/v2"
	vors "go.stargrave.org/vors/v6/internal"
)

func newOpusEnc() *opus.Encoder {
	enc, err := opus.NewEncoder(vors.Rate, 1, opus.AppVoIP)
	if err != nil {
		log.Fatal(err)
	}
	err = enc.SetComplexity(10)
	if err != nil {
		log.Fatal(err)
	}
	err = enc.SetDTX(true)
	if err != nil {
		log.Fatal(err)
	}
	err = enc.SetBitrate(vors.Bitrate)
	if err != nil {
		log.Fatal(err)
	}
	return enc
}

func pcmConv(buf []byte, pcm []int16) {
	for i := range len(pcm) {
		buf[i*2+0] = byte((uint16(pcm[i]) & 0x00FF) >> 0)
		buf[i*2+1] = byte((uint16(pcm[i]) & 0xFF00) >> 8)
	}
}
