package main

import (
	"bytes"
	"flag"
	"fmt"
	"io"
	"log"
	"os"

	vors "go.stargrave.org/vors/v6/internal"
	"go.stargrave.org/vors/v6/pqhs"
)

func usage() {
	fmt.Fprintf(os.Stderr, "Usage: vors-keygen 5>pub 9>prv\n")
	flag.PrintDefaults()
}

func main() {
	version := flag.Bool("version", false, "print version")
	warranty := flag.Bool("warranty", false, "print warranty information")
	flag.Usage = usage
	flag.Parse()
	if *warranty {
		fmt.Println(vors.Warranty)
		return
	}
	if *version {
		fmt.Println(vors.GetVersion())
		return
	}
	prvMcEliece, pubMcEliece, prvX25519, pubX25519, err := pqhs.KeyGen()
	if err != nil {
		log.Fatal(err)
	}
	fdPubW := os.NewFile(5, "pub-out")
	if _, err = io.Copy(fdPubW, bytes.NewReader(pqhs.KeyCombine(pubMcEliece, pubX25519))); err != nil {
		log.Fatal(err)
	}
	fdPrvW := os.NewFile(9, "prv-out")
	if _, err = io.Copy(fdPrvW, bytes.NewReader(pqhs.KeyCombine(prvMcEliece, prvX25519))); err != nil {
		log.Fatal(err)
	}
}
