// VoRS -- Vo(IP) Really Simple
// Copyright (C) 2024-2025 Sergey Matveev <stargrave@stargrave.org>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, version 3 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

package main

import (
	"flag"
	"fmt"
	"io"
	"log"
	"os"
	"strconv"

	vors "go.stargrave.org/vors/v6/internal"
)

func usage() {
	fmt.Fprintf(os.Stderr, "Usage: vors-vad [-rec ...] THRESHOLD\n")
	flag.PrintDefaults()
}

func main() {
	recCmd := flag.String("rec", "rec "+vors.SoxParams, "rec command")
	flag.Usage = usage
	flag.Parse()
	log.SetFlags(log.Lmicroseconds | log.Lshortfile)
	if len(flag.Args()) != 1 {
		usage()
		os.Exit(1)
	}
	thres, err := strconv.ParseUint(flag.Arg(0), 10, 64)
	if err != nil {
		log.Fatal(err)
	}
	buf := make([]byte, 2*vors.FrameLen)
	pcm := make([]int16, vors.FrameLen)
	cmd := vors.MakeCmd(*recCmd)
	mic, err := cmd.StdoutPipe()
	if err != nil {
		log.Fatal(err)
	}
	err = cmd.Start()
	if err != nil {
		log.Fatal(err)
	}
	var rms uint64
	var i int
	for {
		_, err = io.ReadFull(mic, buf)
		if err != nil {
			log.Fatal(err)
		}
		for i = range vors.FrameLen {
			pcm[i] = int16(uint16(buf[i*2+0]) | (uint16(buf[i*2+1]) << 8))
		}
		rms = vors.RMS(pcm)
		if rms > thres {
			fmt.Println(rms)
		}
	}
}
