package internal

import (
	"log"
	"net"
)

const DefaultPort = 12978

var PreferIPv4 bool

func MustResolveTCP(s string) (addr *net.TCPAddr) {
	var err error
	if !PreferIPv4 {
		addr, err = net.ResolveTCPAddr("tcp6", s)
		if err == nil {
			return addr
		}
	}
	addr, err = net.ResolveTCPAddr("tcp4", s)
	if err != nil {
		log.Fatal(err)
	}
	return
}

func MustResolveUDP(s string) (addr *net.UDPAddr) {
	var err error
	if !PreferIPv4 {
		addr, err = net.ResolveUDPAddr("udp6", s)
		if err == nil {
			return addr
		}
	}
	addr, err = net.ResolveUDPAddr("udp4", s)
	if err != nil {
		log.Fatal(err)
	}
	return
}
