package internal

import (
	"net"
	"time"
)

const (
	Magic      = "VoRS v6"
	CmdErr     = "ERR"
	CmdCookie  = "COOKIE"
	CmdSID     = "SID"
	CmdPing    = "PING"
	CmdPong    = "PONG"
	CmdAdd     = "ADD"
	CmdDel     = "DEL"
	CmdMuted   = "MUTED"
	CmdUnmuted = "UNMUTED"
	CmdChat    = "CHAT"
)

var (
	PingTime      = 10 * time.Second
	ScreenRefresh = 200 * time.Millisecond
)

func IPHdrLen(ip net.IP) uint64 {
	if ip.To4() == nil {
		return 40
	}
	return 20
}
