package pqhs

import "crypto/ecdh"

func DH(prv *ecdh.PrivateKey, pubRaw []byte) (pub *ecdh.PublicKey, k []byte, err error) {
	x25519 := ecdh.X25519()
	pub, err = x25519.NewPublicKey(pubRaw)
	if err != nil {
		return
	}
	k, err = prv.ECDH(pub)
	return
}
