package pqhs

import (
	"bytes"
	"crypto/sha3"
	"testing"
)

func TestHandshake(t *testing.T) {
	prvMcEliece, pubMcEliece, prvX25519, pubX25519, err := KeyGen()
	if err != nil {
		t.Fatal(err)
	}
	var c *Client
	var payload []byte
	c, payload, err = NewClient(KeyDecombine(KeyCombine(pubMcEliece, pubX25519)))
	if err != nil {
		t.Fatal(err)
	}
	var s *Server
	prvMcEliece, prvX25519 = KeyDecombine(KeyCombine(prvMcEliece, prvX25519))
	s, payload, err = NewServer(
		prvMcEliece, prvX25519,
		sha3.SumSHAKE256(append(pubMcEliece, pubX25519...), 64),
		payload)
	if err != nil {
		t.Fatal(err)
	}
	payload, err = c.Read(payload, []byte("whatever"))
	if err != nil {
		t.Fatal(err)
	}
	var prefinish []byte
	prefinish, err = s.Read(payload)
	if err != nil {
		t.Fatal(err)
	}
	if string(prefinish) != "whatever" {
		t.Fatal("prefinish differs")
	}
	if !bytes.Equal(c.Keymat(1234), s.Keymat(1234)) {
		t.Fatal("bindings differs")
	}
}
