package pqhs

import (
	"crypto/ecdh"
	"crypto/rand"

	"go.stargrave.org/vors/v6/pqhs/mceliece6960119"
)

func KeyGen() (
	prvMcEliece, pubMcEliece, prvX25519, pubX25519 []byte, err error,
) {
	{
		x25519 := ecdh.X25519()
		var prv *ecdh.PrivateKey
		prv, err = x25519.GenerateKey(rand.Reader)
		if err != nil {
			return
		}
		prvX25519 = prv.Bytes()
		pubX25519 = prv.PublicKey().Bytes()
	}
	{
		var pub *mceliece6960119.PublicKey
		var prv *mceliece6960119.PrivateKey
		pub, prv, err = mceliece6960119.GenerateKeyPair()
		if err != nil {
			return
		}
		prvMcEliece, err = prv.MarshalBinary()
		if err != nil {
			return
		}
		pubMcEliece, err = pub.MarshalBinary()
		if err != nil {
			return
		}
	}
	return
}

func KeyCombine(mcEliece, x25519 []byte) []byte {
	return append(mcEliece, x25519...)
}

func KeyDecombine(combined []byte) (mcEliece, x25519 []byte) {
	if len(combined) <= 32 {
		panic("too short combined key")
	}
	mcEliece = combined[:len(combined)-32]
	x25519 = combined[len(combined)-32:]
	return
}
