package internal

import (
	"go.stargrave.org/vors/v6/pqhs/mceliece6960119/math/gf2e12"
	"go.stargrave.org/vors/v6/pqhs/mceliece6960119/math/gf2e13"
)

var ButterfliesReversal4096 = [64]byte{
	0, 32, 16, 48, 8, 40, 24, 56,
	4, 36, 20, 52, 12, 44, 28, 60,
	2, 34, 18, 50, 10, 42, 26, 58,
	6, 38, 22, 54, 14, 46, 30, 62,
	1, 33, 17, 49, 9, 41, 25, 57,
	5, 37, 21, 53, 13, 45, 29, 61,
	3, 35, 19, 51, 11, 43, 27, 59,
	7, 39, 23, 55, 15, 47, 31, 63,
}

var ButterfliesReversal = [128]byte{
	0, 64, 32, 96, 16, 80, 48, 112,
	8, 72, 40, 104, 24, 88, 56, 120,
	4, 68, 36, 100, 20, 84, 52, 116,
	12, 76, 44, 108, 28, 92, 60, 124,
	2, 66, 34, 98, 18, 82, 50, 114,
	10, 74, 42, 106, 26, 90, 58, 122,
	6, 70, 38, 102, 22, 86, 54, 118,
	14, 78, 46, 110, 30, 94, 62, 126,
	1, 65, 33, 97, 17, 81, 49, 113,
	9, 73, 41, 105, 25, 89, 57, 121,
	5, 69, 37, 101, 21, 85, 53, 117,
	13, 77, 45, 109, 29, 93, 61, 125,
	3, 67, 35, 99, 19, 83, 51, 115,
	11, 75, 43, 107, 27, 91, 59, 123,
	7, 71, 39, 103, 23, 87, 55, 119,
	15, 79, 47, 111, 31, 95, 63, 127,
}

var ButterfliesBeta = [7]uint16{2522, 7827, 7801, 8035, 6897, 8167, 3476}

var RadixConversionsMask = [5][2]uint64{
	{0x8888888888888888, 0x4444444444444444},
	{0xC0C0C0C0C0C0C0C0, 0x3030303030303030},
	{0xF000F000F000F000, 0x0F000F000F000F00},
	{0xFF000000FF000000, 0x00FF000000FF0000},
	{0xFFFF000000000000, 0x0000FFFF00000000},
}

var ButterfliesConst = [128][gf2e13.Bits]uint64{
	{
		0x6969969669699696,
		0x9966669966999966,
		0x9966669966999966,
		0xFF0000FF00FFFF00,
		0xCC3333CCCC3333CC,
		0x9966669966999966,
		0x6666666666666666,
		0xA55AA55AA55AA55A,
		0xCCCC33333333CCCC,
		0x5A5A5A5A5A5A5A5A,
		0x55AAAA55AA5555AA,
		0x0FF0F00FF00F0FF0,
		0x5AA55AA5A55AA55A,
	},
	{
		0x6969969669699696,
		0x9966669966999966,
		0x9966669966999966,
		0xFF0000FF00FFFF00,
		0xCC3333CCCC3333CC,
		0x9966669966999966,
		0x6666666666666666,
		0xA55AA55AA55AA55A,
		0xCCCC33333333CCCC,
		0x5A5A5A5A5A5A5A5A,
		0x55AAAA55AA5555AA,
		0x0FF0F00FF00F0FF0,
		0x5AA55AA5A55AA55A,
	},
	{
		0xA55A5AA55AA5A55A,
		0x6969696996969696,
		0x5AA55AA5A55AA55A,
		0x9999999966666666,
		0x3C3CC3C3C3C33C3C,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0xCC33CC3333CC33CC,
		0x0000000000000000,
		0x3C3C3C3C3C3C3C3C,
		0xAA5555AAAA5555AA,
		0xC33C3CC33CC3C33C,
		0x00FFFF0000FFFF00,
	},
	{
		0xA55A5AA55AA5A55A,
		0x6969696996969696,
		0x5AA55AA5A55AA55A,
		0x6666666699999999,
		0xC3C33C3C3C3CC3C3,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0x33CC33CCCC33CC33,
		0x0000000000000000,
		0x3C3C3C3C3C3C3C3C,
		0xAA5555AAAA5555AA,
		0xC33C3CC33CC3C33C,
		0xFF0000FFFF0000FF,
	},
	{
		0xFFFFFFFF00000000,
		0xA5A5A5A55A5A5A5A,
		0x0FF0F00FF00F0FF0,
		0x9669966969966996,
		0x0000FFFFFFFF0000,
		0x33333333CCCCCCCC,
		0xA55A5AA55AA5A55A,
		0x00FFFF0000FFFF00,
		0x0000000000000000,
		0xC33CC33CC33CC33C,
		0x0F0FF0F00F0FF0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAA55555555AAAA,
	},
	{
		0xFFFFFFFF00000000,
		0xA5A5A5A55A5A5A5A,
		0x0FF0F00FF00F0FF0,
		0x6996699696699669,
		0xFFFF00000000FFFF,
		0x33333333CCCCCCCC,
		0x5AA5A55AA55A5AA5,
		0xFF0000FFFF0000FF,
		0xFFFFFFFFFFFFFFFF,
		0xC33CC33CC33CC33C,
		0x0F0FF0F00F0FF0F0,
		0xCCCCCCCCCCCCCCCC,
		0x5555AAAAAAAA5555,
	},
	{
		0xFFFFFFFF00000000,
		0x5A5A5A5AA5A5A5A5,
		0xF00F0FF00FF0F00F,
		0x6996699696699669,
		0x0000FFFFFFFF0000,
		0x33333333CCCCCCCC,
		0x5AA5A55AA55A5AA5,
		0xFF0000FFFF0000FF,
		0xFFFFFFFFFFFFFFFF,
		0xC33CC33CC33CC33C,
		0x0F0FF0F00F0FF0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAA55555555AAAA,
	},
	{
		0xFFFFFFFF00000000,
		0x5A5A5A5AA5A5A5A5,
		0xF00F0FF00FF0F00F,
		0x9669966969966996,
		0xFFFF00000000FFFF,
		0x33333333CCCCCCCC,
		0xA55A5AA55AA5A55A,
		0x00FFFF0000FFFF00,
		0x0000000000000000,
		0xC33CC33CC33CC33C,
		0x0F0FF0F00F0FF0F0,
		0xCCCCCCCCCCCCCCCC,
		0x5555AAAAAAAA5555,
	},
	{
		0xC33C3CC33CC3C33C,
		0x9966669966999966,
		0x9966996699669966,
		0x6969969669699696,
		0xAA55AA5555AA55AA,
		0x9966996699669966,
		0x5AA5A55A5AA5A55A,
		0xC3C3C3C33C3C3C3C,
		0x3CC33CC3C33CC33C,
		0x3333CCCC3333CCCC,
		0x9999999966666666,
		0xC33CC33CC33CC33C,
		0x6666999999996666,
	},
	{
		0x3CC3C33CC33C3CC3,
		0x6699996699666699,
		0x6699669966996699,
		0x6969969669699696,
		0xAA55AA5555AA55AA,
		0x9966996699669966,
		0xA55A5AA5A55A5AA5,
		0xC3C3C3C33C3C3C3C,
		0x3CC33CC3C33CC33C,
		0x3333CCCC3333CCCC,
		0x6666666699999999,
		0x3CC33CC33CC33CC3,
		0x9999666666669999,
	},
	{
		0xC33C3CC33CC3C33C,
		0x9966669966999966,
		0x6699669966996699,
		0x6969969669699696,
		0xAA55AA5555AA55AA,
		0x6699669966996699,
		0x5AA5A55A5AA5A55A,
		0x3C3C3C3CC3C3C3C3,
		0xC33CC33C3CC33CC3,
		0xCCCC3333CCCC3333,
		0x6666666699999999,
		0xC33CC33CC33CC33C,
		0x9999666666669999,
	},
	{
		0x3CC3C33CC33C3CC3,
		0x6699996699666699,
		0x9966996699669966,
		0x6969969669699696,
		0xAA55AA5555AA55AA,
		0x6699669966996699,
		0xA55A5AA5A55A5AA5,
		0x3C3C3C3CC3C3C3C3,
		0xC33CC33C3CC33CC3,
		0xCCCC3333CCCC3333,
		0x9999999966666666,
		0x3CC33CC33CC33CC3,
		0x6666999999996666,
	},
	{
		0xC33C3CC33CC3C33C,
		0x6699996699666699,
		0x6699669966996699,
		0x6969969669699696,
		0x55AA55AAAA55AA55,
		0x9966996699669966,
		0x5AA5A55A5AA5A55A,
		0xC3C3C3C33C3C3C3C,
		0xC33CC33C3CC33CC3,
		0x3333CCCC3333CCCC,
		0x9999999966666666,
		0xC33CC33CC33CC33C,
		0x6666999999996666,
	},
	{
		0x3CC3C33CC33C3CC3,
		0x9966669966999966,
		0x9966996699669966,
		0x6969969669699696,
		0x55AA55AAAA55AA55,
		0x9966996699669966,
		0xA55A5AA5A55A5AA5,
		0xC3C3C3C33C3C3C3C,
		0xC33CC33C3CC33CC3,
		0x3333CCCC3333CCCC,
		0x6666666699999999,
		0x3CC33CC33CC33CC3,
		0x9999666666669999,
	},
	{
		0xC33C3CC33CC3C33C,
		0x6699996699666699,
		0x9966996699669966,
		0x6969969669699696,
		0x55AA55AAAA55AA55,
		0x6699669966996699,
		0x5AA5A55A5AA5A55A,
		0x3C3C3C3CC3C3C3C3,
		0x3CC33CC3C33CC33C,
		0xCCCC3333CCCC3333,
		0x6666666699999999,
		0xC33CC33CC33CC33C,
		0x9999666666669999,
	},
	{
		0x3CC3C33CC33C3CC3,
		0x9966669966999966,
		0x6699669966996699,
		0x6969969669699696,
		0x55AA55AAAA55AA55,
		0x6699669966996699,
		0xA55A5AA5A55A5AA5,
		0x3C3C3C3CC3C3C3C3,
		0x3CC33CC3C33CC33C,
		0xCCCC3333CCCC3333,
		0x9999999966666666,
		0x3CC33CC33CC33CC3,
		0x6666999999996666,
	},
	{
		0x3C3CC3C3C3C33C3C,
		0x55555555AAAAAAAA,
		0xF00FF00F0FF00FF0,
		0x5AA55AA5A55AA55A,
		0x55AAAA55AA5555AA,
		0xF00F0FF0F00F0FF0,
		0x9669699696696996,
		0xA55AA55AA55AA55A,
		0x55555555AAAAAAAA,
		0xCCCC33333333CCCC,
		0x0000FFFFFFFF0000,
		0xFF0000FF00FFFF00,
		0x6996699669966996,
	},
	{
		0xC3C33C3C3C3CC3C3,
		0x55555555AAAAAAAA,
		0x0FF00FF0F00FF00F,
		0x5AA55AA5A55AA55A,
		0x55AAAA55AA5555AA,
		0xF00F0FF0F00F0FF0,
		0x9669699696696996,
		0x5AA55AA55AA55AA5,
		0x55555555AAAAAAAA,
		0x3333CCCCCCCC3333,
		0x0000FFFFFFFF0000,
		0x00FFFF00FF0000FF,
		0x9669966996699669,
	},
	{
		0x3C3CC3C3C3C33C3C,
		0x55555555AAAAAAAA,
		0xF00FF00F0FF00FF0,
		0xA55AA55A5AA55AA5,
		0xAA5555AA55AAAA55,
		0x0FF0F00F0FF0F00F,
		0x9669699696696996,
		0x5AA55AA55AA55AA5,
		0xAAAAAAAA55555555,
		0x3333CCCCCCCC3333,
		0xFFFF00000000FFFF,
		0xFF0000FF00FFFF00,
		0x9669966996699669,
	},
	{
		0xC3C33C3C3C3CC3C3,
		0x55555555AAAAAAAA,
		0x0FF00FF0F00FF00F,
		0xA55AA55A5AA55AA5,
		0xAA5555AA55AAAA55,
		0x0FF0F00F0FF0F00F,
		0x9669699696696996,
		0xA55AA55AA55AA55A,
		0xAAAAAAAA55555555,
		0xCCCC33333333CCCC,
		0xFFFF00000000FFFF,
		0x00FFFF00FF0000FF,
		0x6996699669966996,
	},
	{
		0x3C3CC3C3C3C33C3C,
		0x55555555AAAAAAAA,
		0x0FF00FF0F00FF00F,
		0xA55AA55A5AA55AA5,
		0xAA5555AA55AAAA55,
		0x0FF0F00F0FF0F00F,
		0x6996966969969669,
		0xA55AA55AA55AA55A,
		0xAAAAAAAA55555555,
		0xCCCC33333333CCCC,
		0x0000FFFFFFFF0000,
		0xFF0000FF00FFFF00,
		0x6996699669966996,
	},
	{
		0xC3C33C3C3C3CC3C3,
		0x55555555AAAAAAAA,
		0xF00FF00F0FF00FF0,
		0xA55AA55A5AA55AA5,
		0xAA5555AA55AAAA55,
		0x0FF0F00F0FF0F00F,
		0x6996966969969669,
		0x5AA55AA55AA55AA5,
		0xAAAAAAAA55555555,
		0x3333CCCCCCCC3333,
		0x0000FFFFFFFF0000,
		0x00FFFF00FF0000FF,
		0x9669966996699669,
	},
	{
		0x3C3CC3C3C3C33C3C,
		0x55555555AAAAAAAA,
		0x0FF00FF0F00FF00F,
		0x5AA55AA5A55AA55A,
		0x55AAAA55AA5555AA,
		0xF00F0FF0F00F0FF0,
		0x6996966969969669,
		0x5AA55AA55AA55AA5,
		0x55555555AAAAAAAA,
		0x3333CCCCCCCC3333,
		0xFFFF00000000FFFF,
		0xFF0000FF00FFFF00,
		0x9669966996699669,
	},
	{
		0xC3C33C3C3C3CC3C3,
		0x55555555AAAAAAAA,
		0xF00FF00F0FF00FF0,
		0x5AA55AA5A55AA55A,
		0x55AAAA55AA5555AA,
		0xF00F0FF0F00F0FF0,
		0x6996966969969669,
		0xA55AA55AA55AA55A,
		0x55555555AAAAAAAA,
		0xCCCC33333333CCCC,
		0xFFFF00000000FFFF,
		0x00FFFF00FF0000FF,
		0x6996699669966996,
	},
	{
		0x3C3CC3C3C3C33C3C,
		0xAAAAAAAA55555555,
		0x0FF00FF0F00FF00F,
		0x5AA55AA5A55AA55A,
		0xAA5555AA55AAAA55,
		0xF00F0FF0F00F0FF0,
		0x9669699696696996,
		0xA55AA55AA55AA55A,
		0x55555555AAAAAAAA,
		0xCCCC33333333CCCC,
		0x0000FFFFFFFF0000,
		0xFF0000FF00FFFF00,
		0x6996699669966996,
	},
	{
		0xC3C33C3C3C3CC3C3,
		0xAAAAAAAA55555555,
		0xF00FF00F0FF00FF0,
		0x5AA55AA5A55AA55A,
		0xAA5555AA55AAAA55,
		0xF00F0FF0F00F0FF0,
		0x9669699696696996,
		0x5AA55AA55AA55AA5,
		0x55555555AAAAAAAA,
		0x3333CCCCCCCC3333,
		0x0000FFFFFFFF0000,
		0x00FFFF00FF0000FF,
		0x9669966996699669,
	},
	{
		0x3C3CC3C3C3C33C3C,
		0xAAAAAAAA55555555,
		0x0FF00FF0F00FF00F,
		0xA55AA55A5AA55AA5,
		0x55AAAA55AA5555AA,
		0x0FF0F00F0FF0F00F,
		0x9669699696696996,
		0x5AA55AA55AA55AA5,
		0xAAAAAAAA55555555,
		0x3333CCCCCCCC3333,
		0xFFFF00000000FFFF,
		0xFF0000FF00FFFF00,
		0x9669966996699669,
	},
	{
		0xC3C33C3C3C3CC3C3,
		0xAAAAAAAA55555555,
		0xF00FF00F0FF00FF0,
		0xA55AA55A5AA55AA5,
		0x55AAAA55AA5555AA,
		0x0FF0F00F0FF0F00F,
		0x9669699696696996,
		0xA55AA55AA55AA55A,
		0xAAAAAAAA55555555,
		0xCCCC33333333CCCC,
		0xFFFF00000000FFFF,
		0x00FFFF00FF0000FF,
		0x6996699669966996,
	},
	{
		0x3C3CC3C3C3C33C3C,
		0xAAAAAAAA55555555,
		0xF00FF00F0FF00FF0,
		0xA55AA55A5AA55AA5,
		0x55AAAA55AA5555AA,
		0x0FF0F00F0FF0F00F,
		0x6996966969969669,
		0xA55AA55AA55AA55A,
		0xAAAAAAAA55555555,
		0xCCCC33333333CCCC,
		0x0000FFFFFFFF0000,
		0xFF0000FF00FFFF00,
		0x6996699669966996,
	},
	{
		0xC3C33C3C3C3CC3C3,
		0xAAAAAAAA55555555,
		0x0FF00FF0F00FF00F,
		0xA55AA55A5AA55AA5,
		0x55AAAA55AA5555AA,
		0x0FF0F00F0FF0F00F,
		0x6996966969969669,
		0x5AA55AA55AA55AA5,
		0xAAAAAAAA55555555,
		0x3333CCCCCCCC3333,
		0x0000FFFFFFFF0000,
		0x00FFFF00FF0000FF,
		0x9669966996699669,
	},
	{
		0x3C3CC3C3C3C33C3C,
		0xAAAAAAAA55555555,
		0xF00FF00F0FF00FF0,
		0x5AA55AA5A55AA55A,
		0xAA5555AA55AAAA55,
		0xF00F0FF0F00F0FF0,
		0x6996966969969669,
		0x5AA55AA55AA55AA5,
		0x55555555AAAAAAAA,
		0x3333CCCCCCCC3333,
		0xFFFF00000000FFFF,
		0xFF0000FF00FFFF00,
		0x9669966996699669,
	},
	{
		0xC3C33C3C3C3CC3C3,
		0xAAAAAAAA55555555,
		0x0FF00FF0F00FF00F,
		0x5AA55AA5A55AA55A,
		0xAA5555AA55AAAA55,
		0xF00F0FF0F00F0FF0,
		0x6996966969969669,
		0xA55AA55AA55AA55A,
		0x55555555AAAAAAAA,
		0xCCCC33333333CCCC,
		0xFFFF00000000FFFF,
		0x00FFFF00FF0000FF,
		0x6996699669966996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0xFFFF0000FFFF0000,
		0x3CC3C33C3CC3C33C,
		0x55AA55AA55AA55AA,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0xFFFF0000FFFF0000,
		0x3CC3C33C3CC3C33C,
		0x55AA55AA55AA55AA,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0xFFFF0000FFFF0000,
		0x3CC3C33C3CC3C33C,
		0xAA55AA55AA55AA55,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0xFFFF0000FFFF0000,
		0x3CC3C33C3CC3C33C,
		0xAA55AA55AA55AA55,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0xFFFF0000FFFF0000,
		0xC33C3CC3C33C3CC3,
		0xAA55AA55AA55AA55,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0xFFFF0000FFFF0000,
		0xC33C3CC3C33C3CC3,
		0xAA55AA55AA55AA55,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0xFFFF0000FFFF0000,
		0xC33C3CC3C33C3CC3,
		0x55AA55AA55AA55AA,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0xFFFF0000FFFF0000,
		0xC33C3CC3C33C3CC3,
		0x55AA55AA55AA55AA,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0x0000FFFF0000FFFF,
		0xC33C3CC3C33C3CC3,
		0xAA55AA55AA55AA55,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0x0000FFFF0000FFFF,
		0xC33C3CC3C33C3CC3,
		0xAA55AA55AA55AA55,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0x0000FFFF0000FFFF,
		0xC33C3CC3C33C3CC3,
		0x55AA55AA55AA55AA,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0x0000FFFF0000FFFF,
		0xC33C3CC3C33C3CC3,
		0x55AA55AA55AA55AA,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0x0000FFFF0000FFFF,
		0x3CC3C33C3CC3C33C,
		0x55AA55AA55AA55AA,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0x0000FFFF0000FFFF,
		0x3CC3C33C3CC3C33C,
		0x55AA55AA55AA55AA,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0x0000FFFF0000FFFF,
		0x3CC3C33C3CC3C33C,
		0xAA55AA55AA55AA55,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0xAAAAAAAAAAAAAAAA,
		0x0000FFFF0000FFFF,
		0x3CC3C33C3CC3C33C,
		0xAA55AA55AA55AA55,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0x0000FFFF0000FFFF,
		0x3CC3C33C3CC3C33C,
		0x55AA55AA55AA55AA,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0x0000FFFF0000FFFF,
		0x3CC3C33C3CC3C33C,
		0x55AA55AA55AA55AA,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0x0000FFFF0000FFFF,
		0x3CC3C33C3CC3C33C,
		0xAA55AA55AA55AA55,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0x0000FFFF0000FFFF,
		0x3CC3C33C3CC3C33C,
		0xAA55AA55AA55AA55,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0x0000FFFF0000FFFF,
		0xC33C3CC3C33C3CC3,
		0xAA55AA55AA55AA55,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0x0000FFFF0000FFFF,
		0xC33C3CC3C33C3CC3,
		0xAA55AA55AA55AA55,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0x0000FFFF0000FFFF,
		0xC33C3CC3C33C3CC3,
		0x55AA55AA55AA55AA,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0x0000FFFF0000FFFF,
		0xC33C3CC3C33C3CC3,
		0x55AA55AA55AA55AA,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0xFFFF0000FFFF0000,
		0xC33C3CC3C33C3CC3,
		0xAA55AA55AA55AA55,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0xFFFF0000FFFF0000,
		0xC33C3CC3C33C3CC3,
		0xAA55AA55AA55AA55,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0xFFFF0000FFFF0000,
		0xC33C3CC3C33C3CC3,
		0x55AA55AA55AA55AA,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0xFFFF0000FFFF0000,
		0xC33C3CC3C33C3CC3,
		0x55AA55AA55AA55AA,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0xFFFF0000FFFF0000,
		0x3CC3C33C3CC3C33C,
		0x55AA55AA55AA55AA,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0xFFFF0000FFFF0000,
		0x3CC3C33C3CC3C33C,
		0x55AA55AA55AA55AA,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0xFFFF0000FFFF0000,
		0x3CC3C33C3CC3C33C,
		0xAA55AA55AA55AA55,
		0xFFFF0000FFFF0000,
		0x0F0F0F0FF0F0F0F0,
		0x00FFFF00FF0000FF,
		0xCC3333CC33CCCC33,
		0xFF0000FF00FFFF00,
		0x6996966996696996,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x3CC3C33C3CC3C33C,
		0x5555555555555555,
		0xFFFF0000FFFF0000,
		0x3CC3C33C3CC3C33C,
		0xAA55AA55AA55AA55,
		0x0000FFFF0000FFFF,
		0xF0F0F0F00F0F0F0F,
		0xFF0000FF00FFFF00,
		0x33CCCC33CC3333CC,
		0x00FFFF00FF0000FF,
		0x9669699669969669,
		0xA55A5AA55AA5A55A,
		0x6996966996696996,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
}

var RadixConversionsS = [5][2][gf2e13.Bits]uint64{
	{
		{
			0x3C3CF30C0000C003,
			0x0CCCC3F333C0000C,
			0x03C33F33FCC0C03C,
			0x0003000F3C03C0C0,
			0xF33FF33030CF03F0,
			0x0CF0303300F0CCC0,
			0xFF3F0C0CC0FF3CC0,
			0xCF3CF0FF003FC000,
			0xC00FF3CF0303F300,
			0x3CCC0CC00CF0CC00,
			0xF30FFC3C3FCCFC00,
			0x3F0FC3F0CCF0C000,
			0x3000FF33CCF0F000,
		},
		{
			0x0C0F0FCF0F0CF330,
			0xF0000FC33C3CCF3C,
			0x3C0F3F00C3C300FC,
			0x3C33CCC0F0F3CC30,
			0xC0CFFFFFCCCC30CC,
			0x3FC3F3CCFFFC033F,
			0xFC3030CCCCC0CFCF,
			0x0FCF0C00CCF333C3,
			0xCFFCF33000CFF030,
			0x00CFFCC330F30FCC,
			0x3CCC3FCCC0F3FFF3,
			0xF00F0C3FC003C0FF,
			0x330CCFCC03C0FC33,
		},
	},
	{
		{
			0x0F0F0FF0F000000F,
			0x00FFFFFFFF0000F0,
			0xFFFF00FF00000F00,
			0xFFF000F00F0FF000,
			0xFFF0000F0FF000F0,
			0x00FF000FFF000000,
			0xFF0F0FFF0F0FF000,
			0x0FFF0000000F0000,
			0x00F000F0FFF00F00,
			0x00F00FF00F00F000,
			0xFFF000F000F00000,
			0x00F00F000FF00000,
			0x0000FF0F0000F000,
		},
		{
			0xF0FFFFFFF0F00F00,
			0x00FFF0FFFF0000FF,
			0x00FF00000F0F0FFF,
			0xF000F0000F00FF0F,
			0xFF000000FFF00000,
			0xF0FF000FF00F0FF0,
			0x0F0F0F00FF000F0F,
			0x0F0F00F0F0F0F000,
			0x00F00F00F00F000F,
			0x00F0F0F00000FFF0,
			0xFFFFFF0FF00F0FFF,
			0x0F0FFFF00FFFFFFF,
			0xFFFF0F0FFF0FFF00,
		},
	},
	{
		{
			0x00FF0000000000FF,
			0xFFFFFFFFFF00FF00,
			0xFF0000FF00FF0000,
			0xFFFF000000FF0000,
			0xFF00000000FF0000,
			0x00FFFFFFFF000000,
			0xFF0000FFFFFF0000,
			0xFF00FF00FFFF0000,
			0x00FFFFFFFF00FF00,
			0xFFFF000000000000,
			0x00FF0000FF000000,
			0xFF00FF00FF000000,
			0x00FF00FFFF000000,
		},
		{
			0x00FF00FF00FF0000,
			0xFF00FFFF000000FF,
			0x0000FFFF000000FF,
			0x00FFFF00FF000000,
			0xFFFFFF0000FF00FF,
			0x0000FFFF00FFFF00,
			0xFF00FF0000FFFF00,
			0x00000000FFFFFFFF,
			0x0000FF0000000000,
			0xFF00FFFF00FFFF00,
			0x00FFFF00000000FF,
			0x0000FF00FF00FFFF,
			0xFF0000FFFFFF0000,
		},
	},
	{
		{
			0x000000000000FFFF,
			0xFFFFFFFFFFFF0000,
			0x0000000000000000,
			0xFFFF0000FFFF0000,
			0xFFFFFFFFFFFF0000,
			0x0000FFFF00000000,
			0x0000FFFFFFFF0000,
			0xFFFF0000FFFF0000,
			0x0000FFFF00000000,
			0xFFFF000000000000,
			0xFFFF000000000000,
			0xFFFF000000000000,
			0xFFFFFFFF00000000,
		},
		{
			0x0000FFFF00000000,
			0xFFFFFFFF0000FFFF,
			0x00000000FFFFFFFF,
			0x0000000000000000,
			0x0000FFFF00000000,
			0xFFFF0000FFFF0000,
			0x0000FFFFFFFF0000,
			0x0000FFFF0000FFFF,
			0xFFFFFFFF0000FFFF,
			0x00000000FFFF0000,
			0xFFFF0000FFFFFFFF,
			0xFFFF0000FFFFFFFF,
			0x0000000000000000,
		},
	},
	{
		{
			0x00000000FFFFFFFF,
			0x0000000000000000,
			0xFFFFFFFF00000000,
			0x0000000000000000,
			0xFFFFFFFF00000000,
			0xFFFFFFFF00000000,
			0xFFFFFFFF00000000,
			0x0000000000000000,
			0xFFFFFFFF00000000,
			0x0000000000000000,
			0x0000000000000000,
			0x0000000000000000,
			0xFFFFFFFF00000000,
		},
		{
			0x0000000000000000,
			0xFFFFFFFFFFFFFFFF,
			0x0000000000000000,
			0x0000000000000000,
			0x00000000FFFFFFFF,
			0xFFFFFFFF00000000,
			0x0000000000000000,
			0xFFFFFFFFFFFFFFFF,
			0x00000000FFFFFFFF,
			0xFFFFFFFF00000000,
			0xFFFFFFFFFFFFFFFF,
			0xFFFFFFFFFFFFFFFF,
			0xFFFFFFFF00000000,
		},
	},
}

var RadixConversionsS4096 = [5][gf2e12.Bits]uint64{
	{
		0xF3CFC030FC30F003,
		0x3FCF0F003C00C00C,
		0x30033CC300C0C03C,
		0xCCFF0F3C0F30F0C0,
		0x0300C03FF303C3F0,
		0x3FFF3C0FF0CCCCC0,
		0xF3FFF0C00F3C3CC0,
		0x3003333FFFC3C000,
		0x0FF30FFFC3FFF300,
		0xFFC0F300F0F0CC00,
		0xC0CFF3FCCC3CFC00,
		0xFC3C03F0F330C000,
	},
	{
		0x000F00000000F00F,
		0x00000F00F00000F0,
		0x0F00000F00000F00,
		0xF00F00F00F000000,
		0x00F00000000000F0,
		0x0000000F00000000,
		0xF00000000F00F000,
		0x00F00F00000F0000,
		0x0000F00000F00F00,
		0x000F00F00F00F000,
		0x00F00F0000000000,
		0x0000000000F00000,
	},
	{
		0x0000FF00FF0000FF,
		0x0000FF000000FF00,
		0xFF0000FF00FF0000,
		0xFFFF0000FF000000,
		0x00FF00FF00FF0000,
		0x0000FFFFFF000000,
		0x00FFFF00FF000000,
		0xFFFFFF0000FF0000,
		0xFFFF00FFFF00FF00,
		0x0000FF0000000000,
		0xFFFFFF00FF000000,
		0x00FF000000000000,
	},
	{
		0x000000000000FFFF,
		0x00000000FFFF0000,
		0x0000000000000000,
		0xFFFF000000000000,
		0x00000000FFFF0000,
		0x0000FFFF00000000,
		0x0000000000000000,
		0x00000000FFFF0000,
		0x0000FFFF00000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
	},
	{
		0x00000000FFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFFFFFF00000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
	},
}

var ButterfliesConsts4096 = [63][gf2e12.Bits]uint64{
	// 64
	{
		0xF00F0FF0F00F0FF0,
		0xF0F00F0F0F0FF0F0,
		0x0FF00FF00FF00FF0,
		0xAA5555AAAA5555AA,
		0xF00F0FF0F00F0FF0,
		0x33CCCC33CC3333CC,
		0xFFFF0000FFFF0000,
		0xCC33CC3333CC33CC,
		0x33CC33CC33CC33CC,
		0x5A5A5A5A5A5A5A5A,
		0xFF00FF00FF00FF00,
		0xF00F0FF0F00F0FF0,
	},
	// 128
	{
		0x3C3C3C3C3C3C3C3C,
		0xF0F0F0F0F0F0F0F0,
		0x5555AAAA5555AAAA,
		0xCC3333CCCC3333CC,
		0xC33CC33CC33CC33C,
		0x55555555AAAAAAAA,
		0x33333333CCCCCCCC,
		0x00FF00FFFF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0x0000FFFFFFFF0000,
		0xF0F00F0F0F0FF0F0,
	},
	{
		0x3C3C3C3C3C3C3C3C,
		0x0F0F0F0F0F0F0F0F,
		0xAAAA5555AAAA5555,
		0xCC3333CCCC3333CC,
		0xC33CC33CC33CC33C,
		0x55555555AAAAAAAA,
		0x33333333CCCCCCCC,
		0xFF00FF0000FF00FF,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0x0000FFFFFFFF0000,
		0xF0F00F0F0F0FF0F0,
	},
	// 256
	{
		0xAA55AA5555AA55AA,
		0xCC33CC3333CC33CC,
		0x33CCCC33CC3333CC,
		0x55555555AAAAAAAA,
		0xFF0000FF00FFFF00,
		0x3CC33CC3C33CC33C,
		0x5555AAAA5555AAAA,
		0x0FF00FF00FF00FF0,
		0xCCCC33333333CCCC,
		0xF0F0F0F0F0F0F0F0,
		0x00FFFF0000FFFF00,
		0xC33CC33CC33CC33C,
	},
	{
		0x55AA55AAAA55AA55,
		0xCC33CC3333CC33CC,
		0xCC3333CC33CCCC33,
		0x55555555AAAAAAAA,
		0xFF0000FF00FFFF00,
		0xC33CC33C3CC33CC3,
		0xAAAA5555AAAA5555,
		0xF00FF00FF00FF00F,
		0x3333CCCCCCCC3333,
		0x0F0F0F0F0F0F0F0F,
		0xFF0000FFFF0000FF,
		0xC33CC33CC33CC33C,
	},
	{
		0xAA55AA5555AA55AA,
		0x33CC33CCCC33CC33,
		0xCC3333CC33CCCC33,
		0x55555555AAAAAAAA,
		0x00FFFF00FF0000FF,
		0x3CC33CC3C33CC33C,
		0x5555AAAA5555AAAA,
		0x0FF00FF00FF00FF0,
		0x3333CCCCCCCC3333,
		0xF0F0F0F0F0F0F0F0,
		0x00FFFF0000FFFF00,
		0xC33CC33CC33CC33C,
	},
	{
		0x55AA55AAAA55AA55,
		0x33CC33CCCC33CC33,
		0x33CCCC33CC3333CC,
		0x55555555AAAAAAAA,
		0x00FFFF00FF0000FF,
		0xC33CC33C3CC33CC3,
		0xAAAA5555AAAA5555,
		0xF00FF00FF00FF00F,
		0xCCCC33333333CCCC,
		0x0F0F0F0F0F0F0F0F,
		0xFF0000FFFF0000FF,
		0xC33CC33CC33CC33C,
	},
	// 512
	{
		0x6699669999669966,
		0x33CCCC33CC3333CC,
		0xA5A5A5A55A5A5A5A,
		0x3C3CC3C3C3C33C3C,
		0xF00FF00F0FF00FF0,
		0x55AA55AA55AA55AA,
		0x3C3CC3C3C3C33C3C,
		0x0F0F0F0FF0F0F0F0,
		0x55AA55AA55AA55AA,
		0x33CCCC33CC3333CC,
		0xF0F0F0F0F0F0F0F0,
		0xA55A5AA55AA5A55A,
	},
	{
		0x9966996666996699,
		0x33CCCC33CC3333CC,
		0xA5A5A5A55A5A5A5A,
		0x3C3CC3C3C3C33C3C,
		0x0FF00FF0F00FF00F,
		0xAA55AA55AA55AA55,
		0x3C3CC3C3C3C33C3C,
		0xF0F0F0F00F0F0F0F,
		0xAA55AA55AA55AA55,
		0xCC3333CC33CCCC33,
		0x0F0F0F0F0F0F0F0F,
		0xA55A5AA55AA5A55A,
	},
	{
		0x6699669999669966,
		0x33CCCC33CC3333CC,
		0x5A5A5A5AA5A5A5A5,
		0xC3C33C3C3C3CC3C3,
		0x0FF00FF0F00FF00F,
		0xAA55AA55AA55AA55,
		0xC3C33C3C3C3CC3C3,
		0x0F0F0F0FF0F0F0F0,
		0xAA55AA55AA55AA55,
		0x33CCCC33CC3333CC,
		0xF0F0F0F0F0F0F0F0,
		0xA55A5AA55AA5A55A,
	},
	{
		0x9966996666996699,
		0x33CCCC33CC3333CC,
		0x5A5A5A5AA5A5A5A5,
		0xC3C33C3C3C3CC3C3,
		0xF00FF00F0FF00FF0,
		0x55AA55AA55AA55AA,
		0xC3C33C3C3C3CC3C3,
		0xF0F0F0F00F0F0F0F,
		0x55AA55AA55AA55AA,
		0xCC3333CC33CCCC33,
		0x0F0F0F0F0F0F0F0F,
		0xA55A5AA55AA5A55A,
	},
	{
		0x6699669999669966,
		0xCC3333CC33CCCC33,
		0x5A5A5A5AA5A5A5A5,
		0x3C3CC3C3C3C33C3C,
		0x0FF00FF0F00FF00F,
		0x55AA55AA55AA55AA,
		0x3C3CC3C3C3C33C3C,
		0x0F0F0F0FF0F0F0F0,
		0x55AA55AA55AA55AA,
		0x33CCCC33CC3333CC,
		0xF0F0F0F0F0F0F0F0,
		0xA55A5AA55AA5A55A,
	},
	{
		0x9966996666996699,
		0xCC3333CC33CCCC33,
		0x5A5A5A5AA5A5A5A5,
		0x3C3CC3C3C3C33C3C,
		0xF00FF00F0FF00FF0,
		0xAA55AA55AA55AA55,
		0x3C3CC3C3C3C33C3C,
		0xF0F0F0F00F0F0F0F,
		0xAA55AA55AA55AA55,
		0xCC3333CC33CCCC33,
		0x0F0F0F0F0F0F0F0F,
		0xA55A5AA55AA5A55A,
	},
	{
		0x6699669999669966,
		0xCC3333CC33CCCC33,
		0xA5A5A5A55A5A5A5A,
		0xC3C33C3C3C3CC3C3,
		0xF00FF00F0FF00FF0,
		0xAA55AA55AA55AA55,
		0xC3C33C3C3C3CC3C3,
		0x0F0F0F0FF0F0F0F0,
		0xAA55AA55AA55AA55,
		0x33CCCC33CC3333CC,
		0xF0F0F0F0F0F0F0F0,
		0xA55A5AA55AA5A55A,
	},
	{
		0x9966996666996699,
		0xCC3333CC33CCCC33,
		0xA5A5A5A55A5A5A5A,
		0xC3C33C3C3C3CC3C3,
		0x0FF00FF0F00FF00F,
		0x55AA55AA55AA55AA,
		0xC3C33C3C3C3CC3C3,
		0xF0F0F0F00F0F0F0F,
		0x55AA55AA55AA55AA,
		0xCC3333CC33CCCC33,
		0x0F0F0F0F0F0F0F0F,
		0xA55A5AA55AA5A55A,
	},
	// 1024
	{
		0x9669699696696996,
		0x6996699669966996,
		0x6996699669966996,
		0x00FFFF0000FFFF00,
		0xFF00FF00FF00FF00,
		0xF00FF00F0FF00FF0,
		0xF0F00F0F0F0FF0F0,
		0xC33C3CC33CC3C33C,
		0xC33C3CC33CC3C33C,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x6996699669966996,
		0x6996699669966996,
		0x00FFFF0000FFFF00,
		0x00FF00FF00FF00FF,
		0x0FF00FF0F00FF00F,
		0x0F0FF0F0F0F00F0F,
		0x3CC3C33CC33C3CC3,
		0x3CC3C33CC33C3CC3,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x6996699669966996,
		0x6996699669966996,
		0xFF0000FFFF0000FF,
		0x00FF00FF00FF00FF,
		0x0FF00FF0F00FF00F,
		0x0F0FF0F0F0F00F0F,
		0xC33C3CC33CC3C33C,
		0xC33C3CC33CC3C33C,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x6996699669966996,
		0x6996699669966996,
		0xFF0000FFFF0000FF,
		0xFF00FF00FF00FF00,
		0xF00FF00F0FF00FF0,
		0xF0F00F0F0F0FF0F0,
		0x3CC3C33CC33C3CC3,
		0x3CC3C33CC33C3CC3,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x6996699669966996,
		0x9669966996699669,
		0xFF0000FFFF0000FF,
		0x00FF00FF00FF00FF,
		0xF00FF00F0FF00FF0,
		0xF0F00F0F0F0FF0F0,
		0xC33C3CC33CC3C33C,
		0xC33C3CC33CC3C33C,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x6996699669966996,
		0x9669966996699669,
		0xFF0000FFFF0000FF,
		0xFF00FF00FF00FF00,
		0x0FF00FF0F00FF00F,
		0x0F0FF0F0F0F00F0F,
		0x3CC3C33CC33C3CC3,
		0x3CC3C33CC33C3CC3,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x6996699669966996,
		0x9669966996699669,
		0x00FFFF0000FFFF00,
		0xFF00FF00FF00FF00,
		0x0FF00FF0F00FF00F,
		0x0F0FF0F0F0F00F0F,
		0xC33C3CC33CC3C33C,
		0xC33C3CC33CC3C33C,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x6996699669966996,
		0x9669966996699669,
		0x00FFFF0000FFFF00,
		0x00FF00FF00FF00FF,
		0xF00FF00F0FF00FF0,
		0xF0F00F0F0F0FF0F0,
		0x3CC3C33CC33C3CC3,
		0x3CC3C33CC33C3CC3,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x9669966996699669,
		0x9669966996699669,
		0x00FFFF0000FFFF00,
		0xFF00FF00FF00FF00,
		0xF00FF00F0FF00FF0,
		0xF0F00F0F0F0FF0F0,
		0xC33C3CC33CC3C33C,
		0xC33C3CC33CC3C33C,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x9669966996699669,
		0x9669966996699669,
		0x00FFFF0000FFFF00,
		0x00FF00FF00FF00FF,
		0x0FF00FF0F00FF00F,
		0x0F0FF0F0F0F00F0F,
		0x3CC3C33CC33C3CC3,
		0x3CC3C33CC33C3CC3,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x9669966996699669,
		0x9669966996699669,
		0xFF0000FFFF0000FF,
		0x00FF00FF00FF00FF,
		0x0FF00FF0F00FF00F,
		0x0F0FF0F0F0F00F0F,
		0xC33C3CC33CC3C33C,
		0xC33C3CC33CC3C33C,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x9669966996699669,
		0x9669966996699669,
		0xFF0000FFFF0000FF,
		0xFF00FF00FF00FF00,
		0xF00FF00F0FF00FF0,
		0xF0F00F0F0F0FF0F0,
		0x3CC3C33CC33C3CC3,
		0x3CC3C33CC33C3CC3,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x9669966996699669,
		0x6996699669966996,
		0xFF0000FFFF0000FF,
		0x00FF00FF00FF00FF,
		0xF00FF00F0FF00FF0,
		0xF0F00F0F0F0FF0F0,
		0xC33C3CC33CC3C33C,
		0xC33C3CC33CC3C33C,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x9669966996699669,
		0x6996699669966996,
		0xFF0000FFFF0000FF,
		0xFF00FF00FF00FF00,
		0x0FF00FF0F00FF00F,
		0x0F0FF0F0F0F00F0F,
		0x3CC3C33CC33C3CC3,
		0x3CC3C33CC33C3CC3,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x9669966996699669,
		0x6996699669966996,
		0x00FFFF0000FFFF00,
		0xFF00FF00FF00FF00,
		0x0FF00FF0F00FF00F,
		0x0F0FF0F0F0F00F0F,
		0xC33C3CC33CC3C33C,
		0xC33C3CC33CC3C33C,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	{
		0x9669699696696996,
		0x9669966996699669,
		0x6996699669966996,
		0x00FFFF0000FFFF00,
		0x00FF00FF00FF00FF,
		0xF00FF00F0FF00FF0,
		0xF0F00F0F0F0FF0F0,
		0x3CC3C33CC33C3CC3,
		0x3CC3C33CC33C3CC3,
		0xA55A5AA55AA5A55A,
		0xC33C3CC33CC3C33C,
		0x3CC3C33C3CC3C33C,
	},
	// 2048
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0000000000000000,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0000000000000000,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFFFFFFFFFF,
		0xFFFFFFFF00000000,
		0xFFFF0000FFFF0000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCCCCCCCCCCCCCC,
		0xAAAAAAAAAAAAAAAA,
	},
}
