package internal

import (
	"go.stargrave.org/vors/v6/pqhs/mceliece6960119/math/gf2e12"
	"go.stargrave.org/vors/v6/pqhs/mceliece6960119/math/gf2e13"
)

var Powers4096 = [64][gf2e12.Bits]uint64{
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0x3333CCCC3333CCCC,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0x0000000000000000,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0xFF00FF00FF00FF00,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0xAAAAAAAAAAAAAAAA,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0xF0F0F0F00F0F0F0F,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0xF0F0F0F0F0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0xFFFF0000FFFF0000,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0x0000000000000000,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0xFFFFFFFFFFFFFFFF,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0xAA55AA55AA55AA55,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
	{
		0x0F0F0F0FF0F0F0F0,
		0x0000FFFF0000FFFF,
		0xFFFFFFFFFFFFFFFF,
		0x0F0F0F0F0F0F0F0F,
		0xFFFFFFFFFFFFFFFF,
		0x55AA55AA55AA55AA,
		0x0F0F0F0FF0F0F0F0,
		0x0000000000000000,
		0x00FF00FF00FF00FF,
		0xF0F0F0F0F0F0F0F0,
		0xCCCC3333CCCC3333,
		0x5555555555555555,
	},
}

var Powers8192 = [128][gf2e13.Bits]uint64{
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0x00000000FFFFFFFF,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0x5A5A5A5A5A5A5A5A,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0xCC33CC33CC33CC33,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0xCC33CC33CC33CC33,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x9696969669696969,
		0xA5A5A5A5A5A5A5A5,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0x0F0FF0F00F0FF0F0,
	},
	{
		0xA55AA55A5AA55AA5,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0x5A5A5A5A5A5A5A5A,
		0xA5A5A5A55A5A5A5A,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0x3CC33CC3C33CC33C,
		0xA5A55A5AA5A55A5A,
		0x0000FFFF0000FFFF,
		0x33CC33CC33CC33CC,
		0xF00FF00F0FF00FF0,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0x5555AAAAAAAA5555,
		0xF00FF00FF00FF00F,
		0xF0F00F0FF0F00F0F,
	},
	{
		0x5AA55AA5A55AA55A,
		0xC33CC33C3CC33CC3,
		0xA5A55A5AA5A55A5A,
		0xFFFF0000FFFF0000,
		0x33CC33CC33CC33CC,
		0x0FF00FF0F00FF00F,
		0xFFFFFFFF00000000,
		0x6969696996969696,
		0xA5A5A5A5A5A5A5A5,
		0x5A5A5A5AA5A5A5A5,
		0xAAAA55555555AAAA,
		0x0FF00FF00FF00FF0,
		0x0F0FF0F00F0FF0F0,
	},
}
