package pqhs

import (
	"crypto/sha3"
	"hash"
	"io"
)

type SHAKE struct {
	xof *sha3.SHAKE
}

func (h SHAKE) Size() int {
	return 64
}

func (h SHAKE) BlockSize() int {
	return h.xof.BlockSize()
}

func (h SHAKE) Reset() {
	h.xof.Reset()
}

func (h SHAKE) Write(p []byte) (int, error) {
	return h.xof.Write(p)
}

func (h SHAKE) Sum(b []byte) []byte {
	buf := make([]byte, 64)
	if _, err := io.ReadFull(h.xof, buf); err != nil {
		panic(err)
	}
	return append(b, buf...)
}

func NewSHAKE256() hash.Hash {
	return SHAKE{xof: sha3.NewSHAKE256()}
}
