// Package kem provides a unified interface for Streamlined NTRU Prime KEM schemes.
package kem

import (
	"io"

	"go.stargrave.org/vors/v6/pqhs/sntrup761/kem"
)

// A Scheme represents a specific instance of a NTRU PRIME KEM.
type Scheme interface {
	kem.Scheme

	// DeriveKeyPairFromGen deterministicallly derives a pair of keys from a nist DRBG.
	// Only used for deterministic testing
	DeriveKeyPairFromGen(gen *io.Reader) (kem.PublicKey, kem.PrivateKey)
}
