// Package schemes contains a register of Streamlined NTRU Prime KEM schemes.
//
// # Schemes Implemented
//
// Post-quantum kems:
//
//	SNTRUP653, SNTRUP761, SNTRUP857, SNTRUP953, SNTRUP1013, SNTRUP1277
package sntrupSchemes

import (
	"strings"

	"go.stargrave.org/vors/v6/pqhs/sntrup761/kem/ntruprime/sntrup761"
	"go.stargrave.org/vors/v6/pqhs/sntrup761/pke/ntruprime/kem"
)

var allSchemes = [...]kem.Scheme{
	sntrup761.SntrupScheme(),
}

var allSchemeNames map[string]kem.Scheme

func init() {
	allSchemeNames = make(map[string]kem.Scheme)
	for _, scheme := range allSchemes {
		allSchemeNames[strings.ToLower(scheme.Name())] = scheme
	}
}

// ByName returns the scheme with the given name and nil if it is not
// supported.
//
// Names are case insensitive.
func ByName(name string) kem.Scheme {
	return allSchemeNames[strings.ToLower(name)]
}

// All returns all KEM schemes supported.
func All() []kem.Scheme { a := allSchemes; return a[:] }
