// netstring -- netstring format serialization library
// Copyright (C) 2015-2024 Sergey Matveev <stargrave@stargrave.org>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, version 3 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// netstring format serialization library.
//
// This is implementation of netstring
// (http://cr.yp.to/proto/netstrings.txt) format for binary string
// serialization.
//
//	var b bytes.Buffer
//	w := netstring.NewWriter(&b)
//	n, _ = w.WriteChunk([]byte("hello")) // n is 8, "5:hello,"
//	n, _ = w.WriteSize(6)                // n is 2
//	n, _ = w.Write([]byte("wor"))        // n is 3
//	n, _ = w.Write([]byte("ld!"))        // n is 3, "5:hello,6:world!,"
//	r := netstring.NewReader(&b)
//	size, err := r.Next()         // size is 5
//	r.Discard()                   // skip that chunk
//	size, err = r.Next()          // size is 6
//	data, _ := io.ReadAll(r)  // data contains "world!"
package netstring
